<?php

use Firebase\JWT\JWT;

/**
 * Provides a Conto Quickpay Payment JWTUtil.
 */
class JWTUtil
{
    public const defaultAlg = 'HS256';

    /**
     * Encode Quickpay token.
     */
    public static function encode($payload, $secret, $alg = JWTUtil::defaultAlg)
    {
        return JWT::encode(
            $payload,
            base64_decode($secret),
            $alg
        );
    }

    /**
     * Decode Quickpay token.
     */
    public static function decode($jwtToken, $secret, $alg = JWTUtil::defaultAlg)
    {
        try {
            return JWT::decode(
                $jwtToken,
                base64_decode($secret),
                [ $alg ]
            );
        } catch (Exception $e) {
            wp_send_json([ 'status' => 'failure', 'message' => 'JWT Decode Error: \'' . $e->getMessage() . '\'' ], 400);
        }
    }
}
