<?php

/**
 * Provides a Conto Quickpay Payment JWTPayload.
 */
class JWTPayload
{
    private $contractId;

    private $amount;

    private $paymentPurpose;

    private $transactionId;

    private $shopName;

    private $shopUrl;

    private $address;

    private $sendOnSuccess;

    private $sendOnFailure;

    private $checkoutId;

    private $enablePeriodicPayment;

    private $periodicStartDate;

    private $periodicEndDate;

    private $periodicFrequency;

    public static function factory()
    {
        return new self();
    }

    public function create()
    {
        $basePayload = [
            'contractId' => $this->contractId,
            'amount' => $this->amount,
            'paymentPurpose' => $this->paymentPurpose,
            'transactionId' => $this->transactionId,
        ];

        if ($this->sendOnSuccess === true || $this->sendOnFailure === true) {
            $basePayload['payerNotificationEmail'] = [
                'address' => $this->address,
                'shopName' => $this->shopName,
                'shopUrl' => $this->shopUrl,
                'sendOnSuccess' => $this->sendOnSuccess,
                'sendOnFailure' => $this->sendOnFailure,
                'checkoutId' => $this->checkoutId,
            ];
        } else {
            $basePayload['payerNotificationEmail'] = null;
        }

        if ($this->enablePeriodicPayment === true) {
            if (
                $this->periodicEndDate &&
                $this->periodicStartDate &&
                strtotime($this->periodicEndDate) < strtotime($this->periodicStartDate)
            ) {
                wc_add_notice('Please select a correct end date. It cannot be earlier than the start date.', 'error');
                return false;
            }

            $basePayload['serviceType'] = "PERIODIC";
            $basePayload['periodicPayment'] = [
                'startDate' => $this->periodicStartDate,
                'endDate' => $this->periodicEndDate,
                'frequency' => $this->periodicFrequency
            ];
        }

        return $basePayload;
    }

    public function setContractId($contractId)
    {
        $this->contractId = $contractId;
        return $this;
    }

    public function setAmount($amount)
    {
        $this->amount = (float) number_format($amount, 2, '.', '');
        return $this;
    }

    public function setPaymentPurpose($paymentPurpose)
    {
        $this->paymentPurpose = $paymentPurpose;
        return $this;
    }

    public function setTransactionId($transactionId)
    {
        $this->transactionId = $transactionId;
        return $this;
    }

    public function setShopName($shopName)
    {
        $this->shopName = $shopName;
        return $this;
    }

    public function setAddress($address)
    {
        $this->address = $address;
        return $this;
    }

    public function setSendOnSuccess($sendOnSuccess)
    {
        $this->sendOnSuccess = $sendOnSuccess;
        return $this;
    }

    public function setSendOnFailure($sendOnFailure)
    {
        $this->sendOnFailure = $sendOnFailure;
        return $this;
    }

    public function setShopUrl($shopUrl)
    {
        $this->shopUrl = $shopUrl;
        return $this;
    }

    public function setCheckoutId($checkoutId)
    {
        $this->checkoutId = $checkoutId;
        return $this;
    }

    public function setEnablePeriodicPayment($enablePeriodicPayment)
    {
        $this->enablePeriodicPayment = $enablePeriodicPayment;
        return $this;
    }

    public function setServiceType($serviceType)
    {
        $this->serviceType = $serviceType;
        return $this;
    }

    public function setPeriodicStartDate($startDate)
    {
        $this->periodicStartDate = $startDate;
        return $this;
    }

    public function setPeriodicEndDate($endDate)
    {
        $this->periodicEndDate = $endDate;
        return $this;
    }

    public function setPeriodicFrequency($frequency)
    {
        $this->periodicFrequency = $frequency;
        return $this;
    }
}
