<?php

/**
 * Provides a Conto Quickpay Payment JWTPayload.
 */
class JWTPayloadCard
{
    private $contractId;

    private $amount;

    private $paymentPurpose;

    private $transactionId;

    private $shopName;

    private $shopUrl;

    private $address;

    private $sendOnSuccess;

    private $sendOnFailure;

    private $checkoutId;

    public static function factory()
    {
        return new self();
    }

    public function create()
    {
        if ($this->sendOnSuccess === true || $this->sendOnFailure === true) {
            return [
                'contractId' => $this->contractId,
                'amount' => $this->amount,
                'paymentPurpose' => $this->paymentPurpose,
                'transactionId' => $this->transactionId,
                'payerNotificationEmail' => [
                    'address' => $this->address,
                    'shopName' => $this->shopName,
                    'shopUrl' => $this->shopUrl,
                    'sendOnSuccess' => $this->sendOnSuccess,
                    'sendOnFailure' => $this->sendOnFailure,
                    'checkoutId' => $this->checkoutId,
                ],
                'cardPayment' => [
                    'clientEmail' => $this->address,
                ],
            ];
        } else {
            return [
                'contractId' => $this->contractId,
                'amount' => $this->amount,
                'paymentPurpose' => $this->paymentPurpose,
                'transactionId' => $this->transactionId,
                'payerNotificationEmail' => null,
                'cardPayment' => [
                    'clientEmail' => $this->address,
                ],
            ];
        }
    }

    public function setContractId($contractId)
    {
        $this->contractId = $contractId;

        return $this;
    }

    public function setAmount($amount)
    {
        $this->amount = (float) number_format($amount, 2, '.', '');

        return $this;
    }

    public function setPaymentPurpose($paymentPurpose)
    {
        $this->paymentPurpose = $paymentPurpose;

        return $this;
    }

    public function setTransactionId($transactionId)
    {
        $this->transactionId = $transactionId;

        return $this;
    }

    public function setShopName($shopName)
    {
        $this->shopName = $shopName;

        return $this;
    }

    public function setAddress($address)
    {
        $this->address = $address;

        return $this;
    }

    public function setSendOnSuccess($sendOnSuccess)
    {
        $this->sendOnSuccess = $sendOnSuccess;

        return $this;
    }

    public function setSendOnFailure($sendOnFailure)
    {
        $this->sendOnFailure = $sendOnFailure;

        return $this;
    }

    public function setShopUrl($shopUrl)
    {
        $this->shopUrl = $shopUrl;

        return $this;
    }

    public function setCheckoutId($checkoutId)
    {
        $this->checkoutId = $checkoutId;

        return $this;
    }
}
