<?php

/**
 * Provides a Conto Quickpay Payment CallbackData.
 */
class CallbackData
{
    public const STATUS_SIGNED    = 'SIGNED';
    public const STATUS_CONFIRMED = 'CONFIRMED';
    public const STATUS_FAILED    = 'FAILED';
    public const STATUS_EXPIRED   = 'EXPIRED';
    public const STATUS_ACTIVE    = 'ACTIVE';
    public const STATUS_CANCELLED = 'CANCELLED';
    public const STATUS_UNRESOLVED = 'UNRESOLVED';

    /**
     * Object with transactions info.
     *
     * @var object
     */
    private $transactions;

    /**
     * Unique order key in woocommerce.
     *
     * @var integer
     */
    private $transactionId;

    /**
     * Status of transaction.
     *
     * @var integer
     */
    private $status;

    public function __construct($decodedJwt)
    {
        $this->transactions  = $decodedJwt->transactions;
        $this->transactionId = $this->transactions[0]->transactionId;
        $this->status        = $this->transactions[0]->status;
        restore_error_handler();
    }

    public function getTransactionId()
    {
        return $this->transactionId;
    }

    public function getTransactios()
    {
        return $this->transactions;
    }

    public function getStatus()
    {
        return $this->status;
    }

    public function isSigned()
    {
        return $this->status == self::STATUS_SIGNED;
    }

    public function isConfirmed()
    {
        return $this->status == self::STATUS_CONFIRMED;
    }

    public function isFailed()
    {
        return $this->status == self::STATUS_FAILED;
    }

    public function isExpired()
    {
        return $this->status == self::STATUS_EXPIRED;
    }

    public function isActive()
    {
        return $this->status == self::STATUS_ACTIVE;
    }

    public function isCancelled()
    {
        return $this->status == self::STATUS_CANCELLED;
    }

    public function isUnresolved()
    {
        return $this->status == self::STATUS_UNRESOLVED;
    }
}
