<?php

/**
 * Provides bank list
 */
class BankSelector
{
    public static function load_bank_selection_list(): string
    {
        $banksSettings           = self::getPluginSetting();
        $banksAvailableList      = $banksSettings['bank_selection'];
        $periodicPaymentsEnabled = $banksSettings['periodic_payments'] === 'yes';
        $remittanceInformation   = $banksSettings['remittance_information'] ?? '';
        $bankActiveList          = [];
        $bankListJson            = file_get_contents(self::getBankListUrl() . ($periodicPaymentsEnabled ? '?contractId=' . urlencode($banksSettings['contract_id']) : ''));
        $bankList                = json_decode($bankListJson);

        foreach ($bankList->countryBanks as $countryBank) {
            foreach ($countryBank->banks as $bank) {
                if ($bank->active) {
                    $bankActiveList[$bank->bic] = [
                        'logo' => $bank->logo,
                        'name' => $bank->name,
                        'periodicPayment' => $bank->periodicPayment ?? null,
                    ];
                }
            }
        }

        $options = [];
        if (!empty($banksAvailableList)) {
            foreach ($bankActiveList as $bic => $data) {
                if (array_key_exists($bic, $banksAvailableList)) {
                    $options[$bic] = $data;
                }
            }
        } else {
            $options = $bankActiveList;
        }

        $html = '<div class="wcq-bank-list-container">';
        foreach ($options as $bic => $data) {
            $html .= '<div class="wcq-bank-list">';
            $html .= '<input type="radio" id="' . $bic . '" name="bank" value="' . $bic . '" data-periodic-payment=\'' . json_encode($data['periodicPayment']) . '\'>';
            $html .= '<label for="' . $bic . '"><img src="' . $data['logo'] . '" alt="' . $data['name'] . '"></label>';
            $html .= '</div>';
        }
        $html .= '</div>';

        if ($periodicPaymentsEnabled && !empty($options)) {
            $html .= '<div class="wcq-periodic-payment-container">';
            $html .= '<label><input type="checkbox" id="enable_periodic_payment" name="enable_periodic_payment" value="yes"> ' . __('Enable Periodic Payments', 'woocommerce-conto-quickpay') . '</label>';
            $html .= '<div class="wcq-periodic-payment-fields">';

            if ($remittanceInformation) {
                $html .= '<label for="remittance_information">' . __('Remittance Information:', 'woocommerce-conto-quickpay') . '</label>';
                $html .= '<span id="remittance_information" class="remittance-text">' . esc_html($remittanceInformation) . '</span>';
            }

            $html .= '<label for="payment_frequency">' . __('Payment Frequency', 'woocommerce-conto-quickpay') . '</label>';
            $html .= '<select id="payment_frequency" name="payment_frequency" class="select"></select>';
            $html .= '<label for="start_date" id="start_date_label">' . __('Start Date', 'woocommerce-conto-quickpay') . '</label>';
            $html .= '<input type="date" id="start_date" name="start_date" class="input-text" required>';
            $html .= '<label for="end_date" id="end_date_label">' . __('End Date', 'woocommerce-conto-quickpay') . ' <span id="opt_text" class="optional"></span></label>';
            $html .= '<input type="date" id="end_date" name="end_date" class="input-text">';
            $html .= '</div>';
            $html .= '</div>';
        }

        return $html;
    }

    public static function get_description(): string
    {
        $translated_description = __('Allows e-shops to receive their payments online from buyers, who have a bank account but do not want to use a payment card, to pay for goods or services.', 'woocommerce-conto-quickpay');
        return '<div class="wcq-bank-list"><input type="radio" checked id="conto_bank_payment" name="bank" value="null"><label for="conto_bank_payment" id="label_conto_bank_payment">' . $translated_description . '</label></div>';
    }

    public static function load_bank_selection_list_for_admin(): array
    {
        $bankListJson  = file_get_contents(self::getBankListUrl());
        $bankList      = json_decode($bankListJson);
        $options       = [];
        foreach ($bankList->countryBanks as $countryBank) {
            if ($countryBank->countryCode === 'LT') {
                foreach ($countryBank->banks as $bank) {
                    if ($bank->active) {
                        $options[$bank->bic] = '<img style="width:100%" src="' . $bank->logo . '" alt="' . $bank->bic . '">';
                    }
                }
            }
        }

        return $options;
    }
    
    private static function getPluginSetting(): array
    {
        return get_option('woocommerce_woocommerce-conto-quickpay_settings');
    }

    private static function getBankListUrl(): string
    {
        return self::getPluginSetting()['host'] . '/api/setup/country-banks';
    }
}
