<?php

use Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType;

/**
 * Conto Payments Blocks integration
 *
 * @since 1.2.0
 */
final class WC_Gateway_Conto_Credit_Card_Blocks_Support extends AbstractPaymentMethodType
{
    /**
     * The gateway instance.
     *
     * @var WC_Gateway_Conto_Quickpay_Credit_Card
     */
    private $gateway;

    /**
     * Payment method name/id/slug.
     *
     * @var string
     */
    protected $name = 'woocommerce-conto-quickpay-credit-card';

    /**
     * Initializes the payment method type.
     */
    public function initialize()
    {
        $this->settings = get_option('woocommerce_woocommerce-conto-quickpay-credit-card_settings');
        $this->gateway  = new WC_Gateway_Conto_Quickpay_Credit_Card();
    }

    /**
     * Returns if this payment method should be active. If false, the scripts will not be enqueued.
     *
     * @return boolean
     */
    public function is_active()
    {
        return $this->gateway->is_available();
    }

    /**
     * Returns an array of scripts/handles to be registered for this payment method.
     *
     * @return array
     */
    public function get_payment_method_script_handles()
    {

        $script_path = self::get_myplugin_url() . 'assets/js/frontend/card_blocks.js';

        $script_asset_path = self::get_myplugin_url() . 'assets/js/frontend/card.blocks.asset.php';

        $script_asset = file_exists($script_asset_path)
            ? require  $script_asset_path
            : [
                'dependencies' => [],
                'version'      => '1.2.0',
            ];
        $script_url   =  $script_path;

        wp_register_script(
            'wc-gateway-conto-quickpay-credit-card-blocks',
            $script_url,
            $script_asset[ 'dependencies' ],
            $script_asset[ 'version' ],
            true
        );


        if (function_exists('wp_set_script_translations')) {
            wp_set_script_translations('wc-gateway-conto-quickpay-credit-card', 'woocommerce-conto-quickpay', self::get_myplugin_url() . 'languages/');
        }

        return [ 'wc-gateway-conto-quickpay-credit-card-blocks' ];
    }

    /**
     * Returns an array of key=>value pairs of data made available to the payment methods script.
     *
     * @return array
     */
    public function get_payment_method_data()
    {

        return [
            'title'       => $this->get_setting('title'),
            'description' => $this->get_setting('description'),
            'supports'    => array_filter($this->gateway->supports, [ $this->gateway, 'supports' ]),
        ];
    }

    public static function get_myplugin_url()
    {
        return plugins_url() . '/woocommerce-conto-quickpay/';
    }
}
