jQuery(function ($) {
    window.addEventListener("beforeunload", function (e) {
        return true;
    });

    $(document).ready(function () {
        let form = $('form.wc-block-components-form.wc-block-checkout__form');
        let $form = $('form.checkout');
        let nonce = wc_nonce['value'];

        function updateNonceFromResponse(xhr) {
            let newNonce = xhr.getResponseHeader('Nonce');
            if (newNonce) {
                nonce = newNonce;
            }
        }

        if (form.length) {
            let $paymentMethod = $('input[name=radio-control-wc-payment-method-options]:checked');

            $(".wc-block-components-form.wc-block-checkout__form").change(function (event) {
                $paymentMethod = $('input[name=radio-control-wc-payment-method-options]:checked').val();
            });

            form.on('click', '.wc-block-components-checkout-place-order-button', function (e) {
                e.stopImmediatePropagation();

                if ($paymentMethod === 'woocommerce-conto-quickpay-credit-card') {
                    const $noticesWrapper = $('div.wc-block-components-notices');
                    if (!$noticesWrapper.last().empty()) {
                        $noticesWrapper.last().remove();
                    }
                    $(this).hide();
                    if ($paymentMethod === 'woocommerce-conto-quickpay-credit-card') {
                        if (is_embedded_card['value'] === 'embedded') {
                            $.ajax({
                                url: '/wp-json/wc/store/cart',
                                method: 'GET',
                                headers: {"Nonce": nonce},
                                success: function (cartData, status, xhr) {
                                    updateNonceFromResponse(xhr);
                                    const cartItems = cartData.items.map(item => ({
                                        product_id: item.product_id,
                                        quantity: item.quantity
                                    }));

                                    $.ajax({
                                        url: '/wp-json/wc/store/v1/checkout',
                                        method: 'POST',
                                        headers: {"Nonce": nonce},
                                        data: {
                                            payment_method: 'woocommerce-conto-quickpay-credit-card',
                                            line_items: cartItems,
                                            billing_address: cartData.billing_address,
                                        },
                                        success: function (checkoutResponse) {
                                            if (checkoutResponse.token) {
                                                const data = {
                                                    token: checkoutResponse.token,
                                                    redirectUrlSuccess: checkoutResponse.redirectUrlSuccess,
                                                    redirectUrlCancel: checkoutResponse.redirectUrlCancel,
                                                    other: checkoutResponse.other,
                                                    webview: checkoutResponse.webview,
                                                    host: checkoutResponse.host,
                                                };

                                                const iframe = $('<iframe>', {
                                                    id: 'cardForm',
                                                    frameBorder: 0,
                                                    scrolling: 'no',
                                                    width: '100%',
                                                    height: '550px',
                                                    overflow: 'hidden'
                                                }).on('load', function () {
                                                    let widget = new QuickPayCardWidget(data.host, data.token, {
                                                        redirectUrlSuccess: null,
                                                        redirectUrlCancel: null,
                                                        embedIn: this.contentWindow.document.body,
                                                        webview: false,
                                                    });

                                                    widget.onSuccess(function () {
                                                        window.top.location = data.redirectUrlSuccess;
                                                    });
                                                    widget.onCancel(function () {
                                                        window.top.location = data.redirectUrlCancel;
                                                    });
                                                    widget.initialize();
                                                });

                                                $('div.wc-block-components-radio-control-accordion-content').prepend(iframe);
                                            }
                                        },
                                        error: function (checkoutError) {
                                            console.error('Error initiating checkout:', checkoutError);
                                        }
                                    });
                                },
                                error: function (error) {
                                    console.error('Error fetching cart items:', error);
                                }
                            });
                        } else {
                            $.ajax({
                                url: '/wp-json/wc/store/cart',
                                method: 'GET',
                                headers: {"Nonce": nonce},
                                success: function (cartData, status, xhr) {
                                    updateNonceFromResponse(xhr);
                                    const cartItems = cartData.items.map(item => ({
                                        product_id: item.product_id,
                                        quantity: item.quantity
                                    }));

                                    $.ajax({
                                        url: '/wp-json/wc/store/v1/checkout',
                                        method: 'POST',
                                        headers: {"Nonce": nonce},
                                        data: {
                                            payment_method: 'woocommerce-conto-quickpay-credit-card',
                                            line_items: cartItems,
                                            billing_address: cartData.billing_address,
                                        },
                                        success: function (checkoutResponse) {
                                            if (checkoutResponse.token) {
                                                const data = {
                                                    token: checkoutResponse.token,
                                                    redirectUrlSuccess: checkoutResponse.redirectUrlSuccess,
                                                    redirectUrlCancel: checkoutResponse.redirectUrlCancel,
                                                    other: checkoutResponse.other,
                                                    webview: checkoutResponse.webview,
                                                    host: checkoutResponse.host,
                                                };

                                                const dataWithoutHost = {...data};
                                                delete dataWithoutHost.host;
                                                const queryParams = new URLSearchParams(dataWithoutHost);
                                                window.location.href = `${data.host}/initialize?${queryParams.toString()}`;
                                            } else {
                                                console.error('Token not found in checkout response');
                                            }
                                        },
                                        error: function (checkoutError) {
                                            console.error('Error initiating checkout:', checkoutError);
                                        }
                                    });
                                },
                                error: function (error) {
                                    console.error('Error fetching cart items:', error);
                                }
                            });
                        }
                    }
                }
            });
        } else {
            let $paymentMethod = $('input[name=payment_method]:checked').val();
            $(".woocommerce-checkout-review-order").change(function () {
                $paymentMethod = $('input[name=payment_method]:checked').val();
            });

            if ($('form#order_review').length === 1) {
                $("form#order_review").submit(function (e) {
                    if ($paymentMethod === 'woocommerce-conto-quickpay-credit-card' && is_popup_card === 'yes') {
                        e.preventDefault();
                        let $urlParams = new URLSearchParams(window.location.search);
                        let $key = $urlParams.get('key');
                        wp.ajax.post("get_token", {product_key: $key})
                            .done(function (data) {
                                if (data.token) {
                                    new QuickPayCardWidget(data.host, data.token, {}).onSuccess(function () {
                                        window.location = data.redirectUrlSuccess;
                                    }).onCancel(function () {
                                    }).initialize();
                                }
                            });
                    }
                });
            }

            $form.on('click', '#place_order', function (e) {
                if ($paymentMethod == 'woocommerce-conto-quickpay-credit-card') {
                    const $noticesWrapper = $('div.woocommerce-notices-wrapper');
                    e.preventDefault();
                    if (!$noticesWrapper.last().empty()) {
                        $noticesWrapper.last().remove();
                    }
                    $(this).hide();
                    if ($paymentMethod === 'woocommerce-conto-quickpay-credit-card') {
                        if (is_embedded_card['value'] === 'embedded') {
                            $.ajax({
                                url: '?wc-ajax=checkout',
                                type: "POST",
                                data: $form.serialize(),
                                success: function (data) {
                                    if (data.result && data.result === 'failure') {
                                        $noticesWrapper.last().html(data.messages);
                                        const top = $noticesWrapper.offset().top;
                                        $('body, html').animate({scrollTop: top}, 800);
                                    }
                                    if (data.token) {
                                        const iframe = $('<iframe>', {
                                            id: 'cardForm',
                                            frameBorder: 0,
                                            scrolling: 'no',
                                            width: '100%',
                                            height: '550px',
                                            overflow: 'hidden'
                                        }).on('load', function () {
                                            let widget = new QuickPayCardWidget(data.host, data.token, {
                                                redirectUrlSuccess: null,
                                                redirectUrlCancel: null,
                                                embedIn: this.contentWindow.document.body,
                                                webview: false,
                                            });

                                            widget.onSuccess(function () {
                                                window.top.location = data.redirectUrlSuccess;
                                            });
                                            widget.onCancel(function () {
                                                window.top.location = data.redirectUrlCancel;
                                            });
                                            widget.initialize();
                                        });

                                        $('div.payment_method_woocommerce-conto-quickpay-credit-card').prepend(iframe);
                                    }
                                },
                                error: function (data) {
                                }
                            });
                        } else {
                            $form.submit();
                        }
                    }
                }
            });
        }
    });
});