document.addEventListener("DOMContentLoaded", function () {
    setTimeout(function () {
        let defaultPaymentMethodElementBlocks = document.querySelector('input[name=radio-control-wc-payment-method-options]:checked');
        if (defaultPaymentMethodElementBlocks !== null) {
            let defaultPaymentMethod = defaultPaymentMethodElementBlocks.value;
            if (defaultPaymentMethod === 'woocommerce-conto-quickpay') {
                getBankListsBlock();
            }
        }
    }, 500);
});

/** Block Flow **/
jQuery(function ($) {
    let nonce = wc_nonce['value'];
    let bankListLoadedBlock = false;

    function updateNonceFromResponse(xhr) {
        const nonceHeader = xhr.getResponseHeader('Nonce');
        if (nonceHeader) {
            nonce = nonceHeader;
        }
    }

    $(document).ready(function () {
        let form = $('form.wc-block-components-form.wc-block-checkout__form');

        if (form.length) {
            let $paymentMethod;

            function updatePaymentMethod() {
                $paymentMethod = $('input[name="radio-control-wc-payment-method-options"]:checked').val();
            }

            function handlePaymentMethodChange() {
                updatePaymentMethod();
                if ($paymentMethod === 'woocommerce-conto-quickpay' && !bankListLoadedBlock) {
                    getBankListsBlock();
                    bankListLoadedBlock = true;
                } else {
                    bankListLoadedBlock = false;
                }
            }

            updatePaymentMethod();

            $(".wc-block-components-form.wc-block-checkout__form").on('change', 'input[name="radio-control-wc-payment-method-options"]', function () {
                handlePaymentMethodChange();
            });

            form.on('click', '.wc-block-components-checkout-place-order-button', function (e) {
                e.preventDefault();
                updatePaymentMethod();

                if ($paymentMethod === 'woocommerce-conto-quickpay') {
                    const $noticesWrapper = $('div.wc-block-components-notices:first');
                    if (!$noticesWrapper.last().empty()) {
                        $noticesWrapper.last().remove();
                    }

                    if (!checkRequiredFields($noticesWrapper, true)) {
                        $('html, body').animate({ scrollTop: $noticesWrapper.offset().top - 100 }, 800);
                        return;
                    }

                    let otherBanks = is_other_banks['value'] === 'yes';
                    let bicValue = $('input[name=bank]:checked').val();
                    let bicValues = 'null';
                    if (typeof is_banklist['value'] === 'object' && Object.keys(is_banklist['value']).length > 0) {
                        bicValues = Object.keys(is_banklist['value']).join(',');
                    }

                    const periodicData = {
                        enable_periodic_payment: $('input[name=enable_periodic_payment]:checked').val() || 'no',
                        payment_frequency: $('#payment_frequency').val() || null,
                        start_date: $('#start_date').val() || null,
                        end_date: $('#end_date').val() || null,
                        remittance_information: $('#remittance_information').val() || null,
                    };

                    if (is_popup['value'] === 'yes') {
                        $.ajax({
                            url: '/wp-json/wc/store/cart',
                            method: 'GET',
                            headers: { "Nonce": nonce },
                            success: function (cartData, status, xhr) {
                                updateNonceFromResponse(xhr);

                                const cartItems = cartData.items.map(item => ({
                                    product_id: item.product_id,
                                    quantity: item.quantity
                                }));

                                $.ajax({
                                    url: '/wp-json/wc/store/v1/checkout',
                                    method: 'POST',
                                    headers: { "Nonce": nonce },
                                    contentType: 'application/json',
                                    data: JSON.stringify({
                                        payment_method: 'woocommerce-conto-quickpay',
                                        line_items: cartItems,
                                        billing_address: cartData.billing_address,
                                        bank: bicValue,
                                        creditor: cartItems,
                                        ...periodicData,
                                    }),
                                    success: function (checkoutResponse) {
                                        if (checkoutResponse.token) {
                                            if (!bicValue) {
                                                bicValue = bicValues;
                                            }

                                            const data = {
                                                token: checkoutResponse.token,
                                                redirectUrlSuccess: checkoutResponse.redirectUrlSuccess,
                                                redirectUrlCancel: checkoutResponse.redirectUrlCancel,
                                                creditor: bicValue,
                                                other: otherBanks,
                                                webview: checkoutResponse.webview,
                                                host: checkoutResponse.host,
                                            };

                                            new QuickPayWidget(data.host, data.token, {
                                                creditor: bicValue,
                                                other: otherBanks,
                                                webview: data.webview,
                                            }).onSuccess(function () {
                                                window.location = data.redirectUrlSuccess;
                                            }).onCancel(function () {
                                                window.location = data.redirectUrlCancel;
                                            }).initialize();
                                        } else {
                                            console.error('No token in checkout response');
                                        }
                                    },
                                    error: function (checkoutError) {
                                        console.error('Checkout error:', checkoutError);
                                    }
                                });
                            },
                            error: function (error) {
                                console.error('Cart error:', error);
                            }
                        });
                    } else {
                        $.ajax({
                            url: '/wp-json/wc/store/cart',
                            method: 'GET',
                            headers: { "Nonce": nonce },
                            success: function (cartData, status, xhr) {
                                updateNonceFromResponse(xhr);

                                const cartItems = cartData.items.map(item => ({
                                    product_id: item.product_id,
                                    quantity: item.quantity
                                }));

                                $.ajax({
                                    url: '/wp-json/wc/store/v1/checkout',
                                    method: 'POST',
                                    headers: { "Nonce": nonce },
                                    contentType: 'application/json',
                                    data: JSON.stringify({
                                        payment_method: 'woocommerce-conto-quickpay',
                                        line_items: cartItems,
                                        billing_address: cartData.billing_address,
                                        bank: bicValue,
                                        creditor: cartItems,
                                        ...periodicData,
                                    }),
                                    success: function (checkoutResponse) {
                                        if (checkoutResponse.token) {
                                            if (!bicValue) {
                                                bicValue = bicValues;
                                            }

                                            const data = {
                                                token: checkoutResponse.token,
                                                redirectUrlSuccess: checkoutResponse.redirectUrlSuccess,
                                                redirectUrlCancel: checkoutResponse.redirectUrlCancel,
                                                creditor: bicValue,
                                                other: otherBanks,
                                                webview: checkoutResponse.webview,
                                                host: checkoutResponse.host,
                                            };

                                            const dataWithoutHost = { ...data };
                                            delete dataWithoutHost.host;

                                            const queryParams = new URLSearchParams(dataWithoutHost);

                                            window.location.href = `${data.host}/initialize?${queryParams.toString()}`;
                                        } else {
                                            console.error('No token in checkout response');
                                        }
                                    },
                                    error: function (checkoutError) {
                                        console.error('Checkout error:', checkoutError);
                                    }
                                });
                            },
                            error: function (error) {
                                console.error('Cart error:', error);
                            }
                        });
                    }
                }
            });
            $(".wc-block-components-form.wc-block-checkout__form").on('change', 'input[name="radio-control-wc-payment-method-options"]', function () {
                handlePaymentMethodChange();
            });

            $('body').on('updated_checkout', function () {
                if ($('input[name="radio-control-wc-payment-method-options"]:checked').val() === 'woocommerce-conto-quickpay') {
                    getBankListsBlock();
                }
            });
        }
    });
});

/** Classic Flow **/
jQuery(function ($) {
    $(document).ready(function () {
        const $form = $('form.checkout');

        if ($form.length) {
            let $paymentMethod;

            $('.woocommerce-checkout-review-order, .wc_payment_methods').change(function () {
                $paymentMethod = $('input[name=payment_method]:checked').val();
            });

            let bicValues = 'null';
            if (typeof is_banklist['value'] === 'object' && Object.keys(is_banklist['value']).length > 0) {
                bicValues = Object.keys(is_banklist['value']).join(',');
            }

            $form.on('click', '#place_order', function (e) {
                if ($paymentMethod === 'woocommerce-conto-quickpay') {
                    e.preventDefault();
                    const $noticesWrapper = $('div.woocommerce-notices-wrapper:first');
                    $noticesWrapper.last().empty();

                    if (!checkRequiredFields($noticesWrapper, false)) {
                        $('html, body').animate({ scrollTop: $noticesWrapper.offset().top - 100 }, 800);
                        return;
                    }

                    let bicValue = $('input[name=bank]:checked').val();
                    let otherBanks = is_other_banks['value'] === 'yes';
                    if (!bicValue) {
                        bicValue = bicValues;
                    }

                    const periodicData = {
                        enable_periodic_payment: $('input[name=enable_periodic_payment]:checked').val(),
                        payment_frequency: $('#payment_frequency').val(),
                        start_date: $('#start_date').val(),
                        end_date: $('#end_date').val(),
                        remittance_information: $('#remittance_information').val(),
                    };

                    if (is_popup['value'] === 'yes') {
                        $.ajax({
                            url: '?wc-ajax=checkout',
                            type: "POST",
                            data: $form.serialize() + '&' + $.param(periodicData),
                            success: function (data) {
                                if (data.result === 'failure') {
                                    $noticesWrapper.last().html(data.messages);
                                    $('html, body').animate({ scrollTop: $noticesWrapper.offset().top }, 800);
                                }

                                if (data.token) {
                                    const widgetData = {
                                        creditor: bicValue,
                                        other: otherBanks,
                                        webview: data.webview,
                                    };

                                    new QuickPayWidget(data.host, data.token, widgetData)
                                        .onSuccess(function () {
                                            window.location = data.redirectUrlSuccess;
                                        })
                                        .onCancel(function () {
                                            window.location = data.redirectUrlCancel;
                                        })
                                        .initialize();
                                }
                            },
                            error: function () {
                                console.error("Error processing QuickPay checkout");
                            }
                        });
                    } else {
                        $form.submit();
                    }
                }
            });
        }
    });
});

function getBankListsBlock() {
    let container = jQuery('.wc-block-components-radio-control__option--woocommerce-conto-quickpay .wc-block-components-radio-control-accordion-content').first();
    if (!container.length) {
        container = jQuery('div.wc-block-components-radio-control-accordion-content').first();
    }

    if (!container.length) {
        console.warn('Block checkout container not found');
        return;
    }

    container.html('');

    if (is_banklist['value']) {
        wp.ajax.post("get_banks", {})
            .done(function (response) {
                if (response.data) {
                    container.append(response.data);

                    if (is_periodic_payments['value'] === 'yes') {
                        const $periodicContainer = container.find('.wcq-periodic-payment-container');
                        const $periodicFields = container.find('.wcq-periodic-payment-fields');
                        const $enablePeriodic = container.find('.enable_periodic_payment');
                        if ($periodicContainer.length) {
                            $periodicContainer.show();
                            $periodicFields.hide();
                            if ($enablePeriodic.is(':checked')) {
                                $periodicFields.show();
                            }
                        }

                        container.find('input[name="bank"]').off('change').on('change', function () {
                            updatePeriodicPaymentFields(container, this.value);
                        });

                        let selectedBank = container.find('input[name="bank"]:checked').val();
                        if (!selectedBank) {
                            selectedBank = container.find('input[name="bank"]').first().val();
                            if (selectedBank) {
                                container.find(`input[name="bank"][value="${selectedBank}"]`).prop('checked', true);
                            }
                        }
                        if (selectedBank) {
                            updatePeriodicPaymentFields(container, selectedBank);
                        }
                    }
                }
            })
            .fail(function (error) {
                console.error("Error fetching bank list:", error);
            });
    } else {
        jQuery(".payment_method_woocommerce-conto-quickpay").css('width', '100%');
        wp.ajax.post("get_description", {})
            .done(function (response) {
                setTimeout(function () {
                    container.append(response.data);
                }, 5);
            });
    }
}
function getBankLists() {
    const container = jQuery('.payment_box.payment_method_woocommerce-conto-quickpay');

    if (!container.length) {
        console.warn('Classic checkout container not found');
        return;
    }

    container.html('');

    if (is_banklist['value']) {
        wp.ajax.post("get_banks", {})
            .done(function (response) {
                if (response.data) {
                    container.html(response.data);

                    if (is_periodic_payments['value'] === 'yes') {
                        const $periodicContainer = container.find('.wcq-periodic-payment-container');
                        const $periodicFields = container.find('.wcq-periodic-payment-fields');
                        const $enablePeriodic = container.find('.enable_periodic_payment');
                        if ($periodicContainer.length) {
                            $periodicContainer.show();
                            $periodicFields.hide();
                            if ($enablePeriodic.is(':checked')) {
                                $periodicFields.show();
                            }
                        }

                        container.find('input[name="bank"]').off('change').on('change', function () {
                            updatePeriodicPaymentFields(container, this.value);
                        });

                        let selectedBank = container.find('input[name="bank"]:checked').val();
                        if (!selectedBank) {
                            selectedBank = container.find('input[name="bank"]').first().val();
                            if (selectedBank) {
                                container.find(`input[name="bank"][value="${selectedBank}"]`).prop('checked', true).trigger('change');
                            }
                        }
                        if (selectedBank) {
                            updatePeriodicPaymentFields(container, selectedBank);
                        }
                    }
                }
            })
            .fail(function (error) {
                console.error("Error fetching bank list:", error);
            });
    }

    if (!is_banklist['value']) {
        wp.ajax.post("get_description", {})
            .done(function (response) {
                if (response.data) {
                    container.append(response.data);
                }
            })
            .fail(function (error) {
                console.error("Error fetching description:", error);
            });
    }
}

function checkRequiredFields($noticesWrapper, isBlockCheckout) {
    const $enablePeriodic = jQuery('#enable_periodic_payment');
    const $endDate = jQuery('#end_date');
    const $startDate = jQuery('#start_date');
    const $selectedBank = jQuery('input[name="bank"]:checked');

    const error = msg => {
        if (isBlockCheckout) {
            $noticesWrapper.append(`
                <div class="wc-block-components-notice-banner is-error" role="alert">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" aria-hidden="true" focusable="false">
                        <path d="M12 3.2c-4.8 0-8.8 3.9-8.8 8.8 0 4.8 3.9 8.8 8.8 8.8 4.8 0 8.8-3.9 8.8-8.8 0-4.8-4-8.8-8.8-8.8zm0 16c-4 0-7.2-3.3-7.2-7.2 0-4 3.2-7.2 7.2-7.2 4 0 7.2 3.2 7.2 7.2 0 4-3.2 7.2-7.2 7.2zm.8-3.9h-1.6v-1.6h1.6v1.6zm0-3.2h-1.6V7.2h1.6v4.9z"></path>
                    </svg>
                    <div class="wc-block-components-notice-banner__content">${msg}</div>
                </div>
            `);
        } else {
            $noticesWrapper.append(`<div class="woocommerce-error" role="alert">${msg}</div>`);
        }
    };

    if (!$enablePeriodic.is(':checked')) return true;

    let periodicData = {};
    if ($selectedBank.length) {
        periodicData = JSON.parse($selectedBank.attr('data-periodic-payment') || '{}');
    }

    const toYMD = d => {
        const pad = n => (n < 10 ? '0' + n : '' + n);
        return `${d.getFullYear()}-${pad(d.getMonth() + 1)}-${pad(d.getDate())}`;
    };
    const parseYMD = s => {
        const [y, m, d] = (s || '').split('-').map(Number);
        if (!y || !m || !d) return null;
        return new Date(y, m - 1, d);
    };
    const addDays = (ymd, days) => {
        const d = parseYMD(ymd);
        if (!d) return null;
        d.setDate(d.getDate() + days);
        return toYMD(d);
    };
    const addMonths = (ymd, months) => {
        const d = parseYMD(ymd);
        if (!d) return null;
        const day = d.getDate();
        d.setDate(1);
        d.setMonth(d.getMonth() + months);
        const lastDay = new Date(d.getFullYear(), d.getMonth() + 1, 0).getDate();
        d.setDate(Math.min(day, lastDay));
        return toYMD(d);
    };
    const todayYMD = toYMD(new Date());

    const selectedInterval = (periodicData.supportedIntervals || [])[0] || {};
    const minStart = selectedInterval.minStartDate;
    const maxDur   = parseInt(periodicData.maxDurationInMonths || 0, 10);
    const maxEnd   = maxDur > 0 ? addMonths(minStart, maxDur) : null;

    let startVal = $startDate.val() || todayYMD;
    if (minStart && parseYMD(startVal) < parseYMD(minStart)) startVal = minStart;
    if (maxEnd && parseYMD(startVal) > parseYMD(maxEnd)) startVal = maxEnd;

    if (!$endDate.val()) {
        error('The end date is required for periodic payments.');
        return false;
    }

    const endVal = $endDate.val();

    const minAllowedEnd = addDays(startVal, 1);
    if (parseYMD(endVal) < parseYMD(minAllowedEnd)) {
        error('The end date must be at least one day after the start date.');
        return false;
    }

    if (minStart && parseYMD(startVal) < parseYMD(minStart)) {
        error(`The start date cannot be earlier than ${minStart}.`);
        return false;
    }
    if (maxEnd && parseYMD(startVal) > parseYMD(maxEnd)) {
        error(`The start date cannot be later than ${maxEnd}.`);
        return false;
    }

    if (maxEnd && parseYMD(endVal) > parseYMD(maxEnd)) {
        error(`The end date cannot be later than ${maxEnd}.`);
        return false;
    }

    return true;
}

function updatePeriodicPaymentFields($container, bic) {
    if (is_periodic_payments['value'] !== 'yes') return;

    const $periodicContainer = $container.find('.wcq-periodic-payment-container');
    const $periodicFields    = $periodicContainer.find('.wcq-periodic-payment-fields');
    const $frequencySelect   = $container.find('#payment_frequency');
    const $startDate         = $container.find('#start_date');
    const $endDate           = $container.find('#end_date');
    const $enablePeriodic    = $container.find('#enable_periodic_payment');

    if (!$periodicContainer.length) {
        console.warn('Periodic payment container not found in the DOM');
        return;
    }

    const $bankInput   = $container.find(`input[name="bank"][value="${bic}"]`);
    const periodicData = $bankInput.length ? JSON.parse($bankInput.attr('data-periodic-payment') || '{}') : {};

    if (!periodicData || !Array.isArray(periodicData.supportedIntervals) || !periodicData.supportedIntervals.length) {
        $periodicContainer.show().css({
            opacity: '0.5',
            pointerEvents: 'none'
        });
        $enablePeriodic.prop('checked', false);
        $periodicFields.hide();
        return;
    }

    $periodicFields.show();
    $periodicContainer.show()
        .css({ opacity: '', pointerEvents: '' });

    const toYMD = d => {
        const pad = n => (n < 10 ? '0' + n : '' + n);
        return `${d.getFullYear()}-${pad(d.getMonth() + 1)}-${pad(d.getDate())}`;
    };
    const toDMY = d => {
        const pad = n => (n < 10 ? '0' + n : '' + n);
        return `${pad(d.getDate())}.${pad(d.getMonth() + 1)}.${d.getFullYear()}`;
    };
    const parseYMD = s => {
        const [y, m, d] = (s || '').split('-').map(Number);
        if (!y || !m || !d) return null;
        const dt = new Date(y, m - 1, d);
        if (dt.getFullYear() !== y || dt.getMonth() !== m - 1 || dt.getDate() !== d) return null;
        return dt;
    };
    const addDays = (dateYmd, days) => {
        const d = parseYMD(dateYmd);
        if (!d) return null;
        d.setDate(d.getDate() + days);
        return toYMD(d);
    };
    const addMonths = (dateYmd, months) => {
        const d = parseYMD(dateYmd);
        if (!d) return null;
        const day = d.getDate();
        d.setDate(1);
        d.setMonth(d.getMonth() + months);
        const lastDay = new Date(d.getFullYear(), d.getMonth() + 1, 0).getDate();
        d.setDate(Math.min(day, lastDay));
        return toYMD(d);
    };
    const todayYMD = toYMD(new Date());

    $frequencySelect.empty();
    periodicData.supportedIntervals.forEach(interval => {
        $frequencySelect.append(
            `<option value="${interval.interval}">${interval.interval.charAt(0) + interval.interval.slice(1).toLowerCase()}</option>`
        );
    });

    function applyBoundaries(selectedInterval) {
        const minStart = selectedInterval.minStartDate;
        const maxDur   = parseInt(periodicData.maxDurationInMonths || 0, 10);
        const maxEnd   = maxDur > 0 ? addMonths(minStart, maxDur) : null;

        let startVal = $startDate.val() || todayYMD;
        if (parseYMD(startVal) < parseYMD(minStart)) startVal = minStart;
        if (maxEnd && parseYMD(startVal) > parseYMD(maxEnd)) startVal = maxEnd;

        $startDate.attr('min', minStart);
        if (maxEnd) $startDate.attr('max', maxEnd); else $startDate.removeAttr('max');
        $startDate.val(startVal);

        const endMin = addDays(startVal, 1);
        $endDate.attr('min', endMin);

        if (maxEnd) $endDate.attr('max', maxEnd); else $endDate.removeAttr('max');

        const endVal = $endDate.val();
        if (endVal) {
            if (parseYMD(endVal) < parseYMD(endMin) || (maxEnd && parseYMD(endVal) > parseYMD(maxEnd))) {
                $endDate.val('');
            }
        }

    }

    function currentInterval() {
        const val = $frequencySelect.val();
        return periodicData.supportedIntervals.find(i => i.interval === val) || periodicData.supportedIntervals[0];
    }

    $enablePeriodic.off('change').on('change', function () {
        $periodicFields.css('display', this.checked ? 'block' : 'none');
        if (this.checked) {
            if (!$frequencySelect.val()) $frequencySelect.val(periodicData.supportedIntervals[0].interval);
            applyBoundaries(currentInterval());
        } else {
            $frequencySelect.val('');
            $startDate.val('');
            $endDate.val('');
        }
    });

    $frequencySelect.off('change').on('change', function () {
        applyBoundaries(currentInterval());
    });

    $startDate.off('change').on('change', function () {
        applyBoundaries(currentInterval());
    });

    if ($enablePeriodic.is(':checked')) {
        if (!$frequencySelect.val()) $frequencySelect.val(periodicData.supportedIntervals[0].interval);
        applyBoundaries(currentInterval());
        $periodicFields.css('display', 'block');
    } else {
        $periodicFields.css('display', 'none');
    }

    $endDate.prop('required', true);
    $endDate.siblings('.optional').hide();
}

jQuery(function ($) {
    $('body').on('updated_checkout', function () {
        getBankLists();
    });

    document.addEventListener("DOMContentLoaded", function () {
        const paymentMethod = document.querySelector('input[name=payment_method]:checked');
        if (paymentMethod && paymentMethod.value === 'woocommerce-conto-quickpay') {
            getBankLists();
        }
    });
});