$(document).ready(function () {
    const checkboxes = document.getElementsByName("payment_method");
    const quickpayPaymentElement = document.querySelector(".quickpay_payment_methods");
    const periodicContainer = document.getElementById("periodic-container");
    const periodicFields = document.getElementById("periodic-fields");
    const enableCheckbox = document.getElementById("quickpay_enable_periodic_payment");
    const frequencySelect = document.getElementById("quickpay_payment_frequency");
    const startDateInput = document.getElementById("quickpay_periodic_start_date");
    const endDateInput = document.getElementById("quickpay_periodic_end_date");
    const optText = document.getElementById("opt_text");
    const periodicEnabled = !!window.quickpayPeriodicPayment;
    let bankListenersInitialized = false;

    function toYMD(d) {
        const pad = n => (n < 10 ? "0" + n : "" + n);
        return `${d.getFullYear()}-${pad(d.getMonth() + 1)}-${pad(d.getDate())}`;
    }

    function parseYMD(s) {
        if (!s) return null;
        const [y, m, d] = s.split("-").map(Number);
        if (!y || !m || !d) return null;
        const dt = new Date(y, m - 1, d);
        return (dt.getFullYear() === y && dt.getMonth() === m - 1 && dt.getDate() === d) ? dt : null;
    }

    function addDays(ymd, days) {
        const d = parseYMD(ymd);
        if (!d) return null;
        d.setDate(d.getDate() + days);
        return toYMD(d);
    }

    function addMonths(ymd, months) {
        const d = parseYMD(ymd);
        if (!d) return null;
        const day = d.getDate();
        d.setDate(1);
        d.setMonth(d.getMonth() + months);
        const lastDay = new Date(d.getFullYear(), d.getMonth() + 1, 0).getDate();
        d.setDate(Math.min(day, lastDay));
        return toYMD(d);
    }

    function showAlertAndScroll(message) {
        const $alert = $(`
                <div class="alert alert-danger alert-dismissible quickpay-alert" role="alert">
                    <button type="button" class="close" data-dismiss="alert">&times;</button>
                    <strong>${message}</strong>
                </div>
            `);
        $(".quickpay_payment_methods").before($alert);
        $alert[0].scrollIntoView({behavior: "smooth"});
    }

    function hidePeriodicAll() {
        if (periodicContainer) periodicContainer.style.display = "none";
        if (periodicFields) periodicFields.style.display = "none";
        if (enableCheckbox) {
            enableCheckbox.checked = false;
            enableCheckbox.disabled = true;
        }
        if (frequencySelect) frequencySelect.innerHTML = "";
        if (startDateInput) {
            startDateInput.value = "";
            startDateInput.removeAttribute("min");
            startDateInput.removeAttribute("max");
        }
        if (endDateInput) {
            endDateInput.value = "";
            endDateInput.removeAttribute("min");
            endDateInput.removeAttribute("max");
            endDateInput.required = false;
        }
        const hiddenEnable = document.getElementById("hidden_enable_periodic_payment");
        if (hiddenEnable) hiddenEnable.value = "";
        if (optText) optText.textContent = "";
    }

    function setupBankListeners() {
        if (bankListenersInitialized) return;
        bankListenersInitialized = true;

        const banks = document.getElementsByName("bank_selection");

        banks.forEach(function (bank) {
            bank.addEventListener("change", function () {
                const logo = document.getElementById("img-" + bank.value);
                const logoInput = document.getElementById("selectedBankLogo");
                if (logo && logoInput) {
                    logoInput.value = logo.src;
                }

                if (!periodicEnabled) {
                    hidePeriodicAll();
                    return;
                }

                const periodicRaw = bank.dataset.periodicPayment;

                if (!periodicRaw) {
                    if (periodicContainer) periodicContainer.style.display = "block";
                    if (periodicFields) periodicFields.style.display = "none";
                    if (enableCheckbox) {
                        enableCheckbox.checked = false;
                        enableCheckbox.disabled = true;
                    }
                    if (frequencySelect) frequencySelect.innerHTML = "";
                    if (startDateInput) {
                        startDateInput.value = "";
                        startDateInput.removeAttribute("min");
                        startDateInput.removeAttribute("max");
                    }
                    if (endDateInput) {
                        endDateInput.value = "";
                        endDateInput.removeAttribute("min");
                        endDateInput.removeAttribute("max");
                        endDateInput.required = false;
                    }
                    if (optText) {
                        optText.textContent = (window.quickpayTranslations?.text_quickpay_periodic_not_supported)
                            || "Periodic payments are not supported by this bank.";
                    }
                    const hiddenEnable = document.getElementById("hidden_enable_periodic_payment");
                    if (hiddenEnable) hiddenEnable.value = "";
                    return;
                }

                let periodic = null;
                try {
                    periodic = JSON.parse(periodicRaw);
                } catch (e) {
                    if (periodicContainer) periodicContainer.style.display = "block";
                    if (periodicFields) periodicFields.style.display = "none";
                    if (enableCheckbox) {
                        enableCheckbox.checked = false;
                        enableCheckbox.disabled = true;
                    }
                    if (frequencySelect) frequencySelect.innerHTML = "";
                    if (startDateInput) {
                        startDateInput.value = "";
                        startDateInput.removeAttribute("min");
                        startDateInput.removeAttribute("max");
                    }
                    if (endDateInput) {
                        endDateInput.value = "";
                        endDateInput.removeAttribute("min");
                        endDateInput.removeAttribute("max");
                        endDateInput.required = false;
                    }
                    if (optText) {
                        optText.textContent = (window.quickpayTranslations?.text_quickpay_periodic_not_supported)
                            || "Periodic payments are not supported by this bank.";
                    }
                    const hiddenEnable = document.getElementById("hidden_enable_periodic_payment");
                    if (hiddenEnable) hiddenEnable.value = "";
                    return;
                }

                if (!periodicContainer || !periodicFields || !enableCheckbox || !frequencySelect || !startDateInput || !endDateInput) {
                    return;
                }

                if (enableCheckbox) {
                    enableCheckbox.disabled = false;
                    enableCheckbox.checked = false;
                }
                if (optText) {
                    optText.textContent = (window.quickpayTranslations?.text_quickpay_periodic_optional)
                        || "Enable periodic payments";
                }

                periodicContainer.style.display = "block";
                periodicFields.style.display = "none";

                frequencySelect.innerHTML = "";
                (periodic.supportedIntervals || []).forEach(function (i) {
                    const opt = document.createElement("option");
                    opt.value = i.interval;
                    opt.text = i.interval.charAt(0).toUpperCase() + i.interval.slice(1).toLowerCase();
                    opt.dataset.minStartDate = i.minStartDate;
                    frequencySelect.appendChild(opt);
                });

                endDateInput.required = true;

                function currentInterval() {
                    const selected = (periodic.supportedIntervals || []).find(i => i.interval === frequencySelect.value);
                    return selected || (periodic.supportedIntervals || [])[0] || null;
                }

                function applyBoundaries() {
                    const sel = currentInterval();
                    if (!sel) return;

                    const minStart = sel.minStartDate;
                    const maxDur = parseInt(periodic.maxDurationInMonths || 0, 10);
                    const maxEnd = maxDur > 0 ? addMonths(minStart, maxDur) : null;

                    let startVal = startDateInput.value || minStart;
                    if (parseYMD(startVal) < parseYMD(minStart)) startVal = minStart;
                    if (maxEnd && parseYMD(startVal) > parseYMD(maxEnd)) startVal = maxEnd;

                    startDateInput.min = minStart;
                    if (maxEnd) {
                        startDateInput.max = maxEnd;
                    } else {
                        startDateInput.removeAttribute("max");
                    }
                    startDateInput.value = startVal;

                    const endMin = addDays(startVal, 1);
                    endDateInput.min = endMin;

                    if (maxEnd) {
                        endDateInput.max = maxEnd;
                    } else {
                        endDateInput.removeAttribute("max");
                    }

                    const endVal = endDateInput.value;
                    if (endVal) {
                        if (parseYMD(endVal) < parseYMD(endMin) || (maxEnd && parseYMD(endVal) > parseYMD(maxEnd))) {
                            endDateInput.value = "";
                        }
                    }
                }

                enableCheckbox.addEventListener("click", function () {
                    const hiddenEnable = document.getElementById("hidden_enable_periodic_payment");
                    if (this.checked) {
                        $("#periodic-fields").removeClass("hidden").css("display", "flex").hide().slideDown(300);
                        const first = (periodic.supportedIntervals || [])[0];
                        if (first) {
                            frequencySelect.value = first.interval;
                        }
                        applyBoundaries();
                        if (hiddenEnable) hiddenEnable.value = "1";
                    } else {
                        $("#periodic-fields").slideUp(300, function () {
                            $(this).css("display", "none");
                        });
                        frequencySelect.value = "";
                        startDateInput.value = "";
                        startDateInput.removeAttribute("min");
                        startDateInput.removeAttribute("max");
                        endDateInput.value = "";
                        endDateInput.removeAttribute("min");
                        endDateInput.removeAttribute("max");
                        if (hiddenEnable) hiddenEnable.value = "";
                    }
                });

                frequencySelect.addEventListener("change", function () {
                    if (!enableCheckbox.checked) return;
                    applyBoundaries();
                });

                startDateInput.addEventListener("change", function () {
                    if (!enableCheckbox.checked) return;
                    applyBoundaries();
                });
            });

            if (bank.checked) {
                bank.dispatchEvent(new Event("change"));
            }
        });
    }

    function showBanksIfQuickpaySelected() {
        if (!checkboxes || !checkboxes.length) return;

        checkboxes.forEach(function (checkbox) {
            checkbox.addEventListener("change", function () {
                if (checkbox.defaultValue === "quickpay" && checkbox.checked) {
                    if (quickpayPaymentElement) {
                        quickpayPaymentElement.style.display = "inline-flex";
                        quickpayPaymentElement.style.flexWrap = "wrap";
                    }
                    if (!periodicEnabled) hidePeriodicAll();
                    setupBankListeners();
                } else {
                    if (quickpayPaymentElement) quickpayPaymentElement.style.display = "none";
                    hidePeriodicAll();
                }
            });

            if (checkbox.defaultValue === "quickpay" && checkbox.checked) {
                if (quickpayPaymentElement) {
                    quickpayPaymentElement.style.display = "inline-flex";
                    quickpayPaymentElement.style.flexWrap = "wrap";
                }
                if (!periodicEnabled) hidePeriodicAll();
                setupBankListeners();
            }
        });
    }

    function validateFormOnSubmit() {
        $("#button-payment-method").on("click", function (e) {
            $(".alert.alert-danger.alert-dismissible.quickpay-alert").remove();

            if (!periodicEnabled || !enableCheckbox || !enableCheckbox.checked) {
                return;
            }

            const today = new Date();
            today.setHours(0, 0, 0, 0);

            const startYmd = startDateInput ? (startDateInput.value || "") : "";
            const endYmd = endDateInput ? (endDateInput.value || "") : "";
            const startDate = parseYMD(startYmd);
            const endDate = parseYMD(endYmd);

            if (startDate && startDate < today) {
                e.stopImmediatePropagation();
                showAlertAndScroll(window.quickpayTranslations?.text_quickpay_start_date_past || "Start date cannot be in the past.");
                return;
            }

            if (endDate && endDate < today) {
                e.stopImmediatePropagation();
                showAlertAndScroll(window.quickpayTranslations?.text_quickpay_end_date_past || "End date cannot be in the past.");
                return;
            }

            if (!endYmd) {
                e.stopImmediatePropagation();
                showAlertAndScroll(window.quickpayTranslations?.text_quickpay_end_date_required || "End date is required for periodic payments.");
                return;
            }

            const endMin = addDays(startYmd || toYMD(new Date()), 1);
            if (parseYMD(endYmd) < parseYMD(endMin)) {
                e.stopImmediatePropagation();
                showAlertAndScroll(
                    window.quickpayTranslations?.text_quickpay_end_date_min ||
                    "End date must be at least one day after the start date."
                );
                return;
            }

            const selectedBank = document.querySelector('input[name="bank_selection"]:checked');
            let maxEnd = null;
            if (selectedBank?.dataset?.periodicPayment) {
                try {
                    const periodic = JSON.parse(selectedBank.dataset.periodicPayment);
                    const arr = periodic.supportedIntervals || [];
                    const chosen = arr.find(i => i.interval === (frequencySelect ? frequencySelect.value : "")) || arr[0];
                    if (chosen) {
                        const maxDur = parseInt(periodic.maxDurationInMonths || 0, 10);
                        if (maxDur > 0) {
                            maxEnd = addMonths(chosen.minStartDate, maxDur);
                        }
                    }
                } catch (err) {}
            }
            if (maxEnd && parseYMD(endYmd) > parseYMD(maxEnd)) {
                e.stopImmediatePropagation();
                showAlertAndScroll(
                    window.quickpayTranslations?.text_quickpay_end_date_too_far ||
                    `End date cannot be later than ${maxEnd}.`
                );
                return;
            }
        });
    }

    if (!periodicEnabled) hidePeriodicAll();

    const selectedPayment = $('input[name="payment_method"]:checked');
    if (selectedPayment.length && selectedPayment.val() === "quickpay") {
        if (!periodicEnabled) hidePeriodicAll();
        setupBankListeners();
    }

    showBanksIfQuickpaySelected();
    validateFormOnSubmit();
});
