<?php

class QuickpayHtmlForm
{
    private $remittanceInformation;
    private $language;
    private $translatedStrings;
    private $periodicPaymentStatus;

    public function __construct(
        $remittanceInformation,
        $language,
        $translatedStrings,
        $periodicPaymentStatus = false)
    {
        $this->remittanceInformation = $remittanceInformation;
        $this->language = $language;
        $this->translatedStrings = $translatedStrings;
        $this->periodicPaymentStatus = $periodicPaymentStatus;
    }

    const LINE_BREAK = '<div style="clear:both"><br /></div>';
    const TEXT_QUICKPAY_OTHER_BANK_SELECTION = 'text_quickpay_other_bank_selection';
    const TEXT_QUICKPAY_PERIODIC_ENABLE = 'text_quickpay_periodic_enable';
    const TEXT_QUICKPAY_REMITTANCE_INFORMATION = 'text_quickpay_remittance_information';
    const TEXT_QUICKPAY_PAYMENT_FREQUENCY = 'text_quickpay_payment_frequency';
    const TEXT_QUICKPAY_PERIODIC_START_DATE = 'text_quickpay_periodic_start_date';
    const TEXT_QUICKPAY_PERIODIC_END_DATE = 'text_quickpay_periodic_end_date';

    public function getMultiplePaymentMethods($banksSelection, $title, $otherBanks, $bankList)
    {
        $titleWithSelection = '';
        $titleWithSelection .= '<script type="text/javascript">';
        $titleWithSelection .= 'window.quickpayTranslations = ' . json_encode($this->translatedStrings, JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_AMP | JSON_HEX_QUOT) . ';';
        $titleWithSelection .= 'window.quickpayPeriodicPayment = ' . $this->periodicPaymentStatus;
        $titleWithSelection .= '</script>';
        $titleWithSelection .= '<script type="text/javascript" src="catalog/view/javascript/quickpay/quickpay.js"></script>';
        $titleWithSelection .= '<link rel="stylesheet" type="text/css" href="catalog/view/theme/default/stylesheet/quickpay.css">';

        $titleWithSelection .= '<div style="margin-bottom: 10px;">'
            . $title .
            ' <img src="catalog/view/theme/default/image/quickpay_logo.png" alt="Conto Quickpay Payment Gateway" title="Conto Quickpay Payment Gateway" />'
            . '</div>';

        $titleWithSelection .= '<div class="quickpay_payment_methods" style="display: none; flex-wrap: wrap;">';

        foreach ($banksSelection as $bic => $logoUrl) {
            $periodicData = self::getPeriodicDataJsonByBic($bic, $bankList);
            $titleWithSelection .= '<label id="label-' . $bic . '" class="quickpay-bank-label">'
                . '<input type="radio" id="quickpay_payment_bank_selection" value="' . $bic . '" name="bank_selection" data-periodic-payment=\'' . htmlspecialchars($periodicData, ENT_QUOTES, 'UTF-8') . '\'>'
                . '<img id="img-' . $bic . '" src="' . $logoUrl . '" />'
                . '</label>';
        }

        if ($otherBanks) {
            $titleWithSelection .= '<label id="label-other-bank" class="quickpay-bank-label">'
                . '<input type="radio" id="other_bank_selection" name="bank_selection" value="null">' . $this->language->get(self::TEXT_QUICKPAY_OTHER_BANK_SELECTION)
                . '</label>';
        }

        $titleWithSelection .= self::LINE_BREAK;
        $titleWithSelection .= '</div>';

        $titleWithSelection .= '<div id="periodic-container" class="wcq-periodic-payment-container" style="display:none">';
        $titleWithSelection .= '<label><input type="checkbox" id="quickpay_enable_periodic_payment">' . '&nbsp;' . $this->language->get(self::TEXT_QUICKPAY_PERIODIC_ENABLE) . '</label>';
        $titleWithSelection .= '<div id="periodic-fields" class="wcq-periodic-payment-fields hidden">';

        if ($this->remittanceInformation) {
            $titleWithSelection .= '<label for="remittance_information" class="remittance_information_title">' . $this->language->get(self::TEXT_QUICKPAY_REMITTANCE_INFORMATION) . ':&nbsp;' . '</label>';
            $titleWithSelection .= '<span id="remittance_information" class="remittance-text">' . htmlspecialchars($this->remittanceInformation, ENT_QUOTES, 'UTF-8') . '</span>';
        }

        $titleWithSelection .= '<div><label for="quickpay_payment_frequency">' . $this->language->get(self::TEXT_QUICKPAY_PAYMENT_FREQUENCY) . '</label>';
        $titleWithSelection .= '<select id="quickpay_payment_frequency" name="payment_frequency" class="form-control"></select></div>';
        $titleWithSelection .= '<div><label for="quickpay_periodic_start_date">' . $this->language->get(self::TEXT_QUICKPAY_PERIODIC_START_DATE) . '</label>';
        $titleWithSelection .= '<input type="date" id="quickpay_periodic_start_date" name="start_date" class="form-control"></div>';
        $titleWithSelection .= '<div><label for="quickpay_periodic_end_date">' . $this->language->get(self::TEXT_QUICKPAY_PERIODIC_END_DATE) . '&nbsp;' . '<span id="opt_text" class="optional"></span></label>';
        $titleWithSelection .= '<input type="date" id="quickpay_periodic_end_date" name="end_date" class="form-control"></div>';
        $titleWithSelection .= '</div>';
        $titleWithSelection .= '</div>';
        $titleWithSelection .= '<div id="quickpay_payment_method"></div>';

        return $titleWithSelection;
    }

    public static function getPeriodicDataJsonByBic($bic, $bankList)
    {
        $json = file_get_contents($bankList);
        $banksData = json_decode($json, true);

        foreach ($banksData['countryBanks'] as $countryBank) {
            foreach ($countryBank['banks'] as $bank) {
                if ($bank['bic'] === $bic && isset($bank['periodicPayment'])) {
                    return json_encode($bank['periodicPayment']);
                }
            }
        }

        return '';
    }
}
