<?php

if (!class_exists('quickpayHtmlForm')) {
    require_once __DIR__ . '/quickpayHtmlForm.php';
}

class ModelExtensionPaymentQuickpay extends Model
{
    const EMPTY_SIGN = '';

    const QUICKPAY = 'quickpay';
    const QUICKPAY_EXTENSION_ROUTE = 'extension/payment/quickpay';

    const PAYMENT_QUICKPAY_STATUS = 'payment_quickpay_status';
    const PAYMENT_QUICKPAY_WIDGET_HOST_URL = 'payment_quickpay_widget_host_url';
    const DEFAULT_HOST = 'https://quickpay.contomobile.com';
    const QUICKPAY_CONTRACT_ID = 'payment_quickpay_contract_id';
    const PAYMENT_QUICKPAY_SORT_ORDER = 'payment_quickpay_sort_order';
    const PAYMENT_QUICKPAY_MINIMUM_TOTAL = 'payment_quickpay_minimum_total';
    const PAYMENT_QUICKPAY_BANKS_SELECTION = 'payment_quickpay_banks_selection';
    const PAYMENT_QUICKPAY_OTHER_BANKS_SELECTION = 'payment_quickpay_other_banks_selection';
    const PAYMENT_QUICKPAY_PERIODIC_PAYMENT_STATUS = 'payment_quickpay_periodic_payment_status';
    const PAYMENT_QUICKPAY_REMITTANCE_INFORMATION = 'payment_quickpay_remittance_information';
    const PAYMENT_QUICKPAY_TITLE = 'text_payment_quickpay_title';
    const TEXT_QUICKPAY_START_DATE_PAST = 'text_quickpay_start_date_past';
    const TEXT_QUICKPAY_END_DATE_REQUIRED = 'text_quickpay_end_date_required';
    const TEXT_QUICKPAY_END_DATE_PAST = 'text_quickpay_end_date_past';

    function bankActivityFilter($banksSelection)
    {
        $bicsWithLogos = array();
        $banksJson = $this->getJsonContent();
        if (empty($banksSelection)) {
            return null;
        }
        foreach ($banksJson['countryBanks'] as $countryBanks) {
            foreach ($countryBanks['banks'] as $banks) {
                if ((($key = array_search($banks['bic'], $banksSelection)) !== false) && $banks['active'] == true) {
                    $bicsWithLogos = array_merge($bicsWithLogos, array($banksSelection[$key] => $banks['logo']));
                }
            }
        }

        return $bicsWithLogos;
    }

    function getHtmlInfusedTitle()
    {
        $otherBanks = $this->getOtherBanks();
        $banksSelection = $this->config->get(self::PAYMENT_QUICKPAY_BANKS_SELECTION);
        $quickpayTitle = $this->language->get(self::PAYMENT_QUICKPAY_TITLE);
        $banksSelection = $this->bankActivityFilter($banksSelection);

        $translatedStrings[self::TEXT_QUICKPAY_START_DATE_PAST] = $this->language->get(self::TEXT_QUICKPAY_START_DATE_PAST);
        $translatedStrings[self::TEXT_QUICKPAY_END_DATE_PAST] = $this->language->get(self::TEXT_QUICKPAY_END_DATE_PAST);
        $translatedStrings[self::TEXT_QUICKPAY_END_DATE_REQUIRED] = $this->language->get(self::TEXT_QUICKPAY_END_DATE_REQUIRED);
        $periodicPaymentStatus  = $this->config->get(self::PAYMENT_QUICKPAY_PERIODIC_PAYMENT_STATUS);

        $paymentsHtmlForm = new QuickpayHtmlForm(
            $this->config->get(self::PAYMENT_QUICKPAY_REMITTANCE_INFORMATION),
            $this->language,
            $translatedStrings,
            $periodicPaymentStatus);

        $quickpayTitle = $paymentsHtmlForm->getMultiplePaymentMethods($banksSelection, $quickpayTitle, $otherBanks, ($this->getBankListUrl() . (self::PAYMENT_QUICKPAY_PERIODIC_PAYMENT_STATUS ? '?contractId=' . $this->getContractId() : '')));

        return $quickpayTitle;
    }

    function getOtherBanks()
    {
        return (bool)$this->config->get(self::PAYMENT_QUICKPAY_OTHER_BANKS_SELECTION);
    }
    function getJsonContent(){
        $json = file_get_contents($this->getBankListUrl() . (self::PAYMENT_QUICKPAY_PERIODIC_PAYMENT_STATUS ? '?contractId=' . $this->getContractId() : ''));
        $banksJson = json_decode($json, true);
        return $banksJson;
    }

    public function getMethod($address, $total)
    {
        $this->load->language(self::QUICKPAY_EXTENSION_ROUTE);

        if ($this->config->get(self::PAYMENT_QUICKPAY_STATUS)) {
            $minimumTotal = $this->config->get(self::PAYMENT_QUICKPAY_MINIMUM_TOTAL);
            if ($minimumTotal > 0 && $minimumTotal > $total) {
                $status = false;
            } else {
                $status = true;
            }
        } else {
            $status = false;
        }

        $title = $this->getHtmlInfusedTitle();

        if ($status) {
            return array(
                'code' => self::QUICKPAY,
                'title' => $title,
                'terms' => self::EMPTY_SIGN,
                'sort_order' => $this->config->get(self::PAYMENT_QUICKPAY_SORT_ORDER)
            );
        } else exit();
    }

    private function getBankListUrl(): string
    {
        $host = $this->config->get(self::PAYMENT_QUICKPAY_WIDGET_HOST_URL) ?? $this->config->get(self::DEFAULT_HOST);
        return $host . '/api/setup/country-banks';
    }

    private function getContractId(): string
    {
        return $this->config->get(self::QUICKPAY_CONTRACT_ID);
    }
}
