<?php

class WidgetLoader
{
    private $token;
    private $widgetConfig;
    private $widgetHostUrl;
    private $otherBanks;

    const defaultWidgetHostUrl = 'https://quickpay.contomobile.com';

    public static function factory()
    {
        return new self();
    }

    public function load()
    {
        $this->validate();
        $this->loadWidget();
    }

    private function validate()
    {
        if (!isset($this->token) || !isset($this->widgetConfig)) {
            //todo exception
            var_dump("JWT token and widget config must be provided to widget loader.");
        }
    }

    private function loadWidget()
    {
        echo '<script type="text/javascript" src=' . $this->widgetHostUrl . '/static/widget.js></script>';
        echo '<script type="text/javascript">';
        echo "loadWidget($this->widgetConfig, '$this->token', '$this->widgetHostUrl');";
        echo '</script>';
    }

    public function setToken($token)
    {
        $this->token = $token;
        return $this;
    }

    public function setWidgetConfig($widgetConfig)
    {
        $this->widgetConfig = $widgetConfig;
        return $this;
    }

    public function setWidgetHostUrl($widgetHostUrl)
    {
        if(empty($widgetHostUrl)){
            $this->widgetHostUrl = self::defaultWidgetHostUrl;
        } else {
            $this->widgetHostUrl = $widgetHostUrl;
        }
        return $this;
    }
    public function setOtherBanks($otherBanks)
    {
        $this->otherBanks = $otherBanks;
        return $this;
    }


}