<?php

class WidgetConfig
{
    private $redirectUrlSuccess = null;
    private $redirectUrlCancel = null;
    private $defaultLanguage = 'lit';
    private $defaultCountry = 'LT';
    private $creditor = null;
    private $other = true;
    private $webview = false;
    private $usesKevin = null;

    public static function factory()
    {
        return new self();
    }

    /**
     * @return false|string
     * @noinspection PhpComposerExtensionStubsInspection
     */
    public function create()
    {
        return json_encode(array(
            'redirectUrlSuccess' => $this->redirectUrlSuccess,
            'redirectUrlCancel' => $this->redirectUrlCancel,
            'defaultLanguage' => $this->defaultLanguage,
            'defaultCountry' => $this->defaultCountry,
            'creditor' => $this->creditor,
            'usesKevin' => $this->usesKevin,
            'other' => $this->other,
            'webview' => $this->webview,
        ));
    }

    public function setRedirectUrlSuccess($redirectUrlSuccess)
    {
        $this->redirectUrlSuccess = $redirectUrlSuccess;
        return $this;
    }

    public function setRedirectUrlCancel($redirectUrlCancel)
    {
        $this->redirectUrlCancel = $redirectUrlCancel;
        return $this;
    }

    public function setDefaultLanguage($defaultLanguage)
    {
        $this->defaultLanguage = $defaultLanguage;
        return $this;
    }

    public function setDefaultCountry($defaultCountry)
    {
        $this->defaultCountry = $defaultCountry;
        return $this;
    }

    public function setCreditor($creditor)
    {
        $this->creditor = $creditor;
        return $this;
    }

    public function setOther($other)
    {
        $this->other = $other;
        return $this;
    }

    public function setWebview($webview)
    {
        $this->webview = $webview;
        return $this;
    }

    public function setUsesKevin($usesKevin)
    {
        $this->usesKevin = $usesKevin;
        return $this;
    }

}