<?php

use Firebase\JWT\JWT;

class JWTUtil
{
    const defaultAlg = 'HS256';

    public static function encode($payload, $secret, $alg = JWTUtil::defaultAlg)
    {
        return JWT::encode(
            $payload,
            base64_decode($secret),
            $alg);
    }

    /**
     * @param $jwtToken
     * @param $secret
     * @param string $algorithm
     * @return object
     * @throws JWTDecodeException (UnexpectedValueException/SignatureInvalidException/BeforeValidException/ExpiredException)
     */
    public static function decode($jwtToken, $secret, $algorithm = JWTUtil::defaultAlg) {
        try {
            return JWT::decode(
                $jwtToken,
                base64_decode($secret),
                array($algorithm));
        } catch (Exception $e) {
            throw new JWTDecodeException($e);
        }
    }

}