<?php

class CallbackData
{
    const STATUS_SIGNED = 'SIGNED';
    const STATUS_CONFIRMED = 'CONFIRMED';
    const STATUS_FAILED = 'FAILED';
    const STATUS_EXPIRED = 'EXPIRED';
    const STATUS_ACTIVE    = 'ACTIVE';
    const STATUS_CANCELLED = 'CANCELLED';
    const STATUS_UNRESOLVED = 'UNRESOLVED';

    /**
     * @var $transactions multiple transactions (for now only one is included)
     */
    private $transactions;

    private $transactionId;
    private $status;

    /**
     * CallbackResponse constructor.
     * @param $decodedJwt
     * @throws CallbackParseException
     */
    public function __construct($decodedJwt)
    {
        set_error_handler(function($severity, $message){
            throw new CallbackParseException($message);
        });
        $this->transactions = $decodedJwt->transactions;
        $this->transactionId = $this->transactions[0]->transactionId;
        $this->status = $this->transactions[0]->status;
        restore_error_handler();
    }

    public function getTransactionId()
    {
        return $this->transactionId;
    }

    public function getStatus()
    {
        return $this->status;
    }

    public function isSigned()
    {
        return $this->status == self::STATUS_SIGNED;
    }

    public function isConfirmed()
    {
        return $this->status == self::STATUS_CONFIRMED;
    }

    public function isFailed()
    {
        return $this->status == self::STATUS_FAILED;
    }

    public function isExpired()
    {
        return $this->status == self::STATUS_EXPIRED;
    }

    public function isActive()
    {
        return $this->status == self::STATUS_ACTIVE;
    }

    public function isCancelled()
    {
        return $this->status == self::STATUS_CANCELLED;
    }

    public function isUnresolved()
    {
        return $this->status == self::STATUS_UNRESOLVED;
    }
}
