<?php

$_['heading_title'] = 'Conto QuickPay Payment Gateway';

//TABS
$_['tab_main_configuration'] = 'Main Configuration';
$_['tab_order_status'] = 'Order Status';
$_['tab_security'] = 'Security';
$_['tab_bank_selection'] = 'Bank Selection';
$_['tab_email_notification'] = 'E-mail notification';

//LABELS
$_['label_payment_quickpay_status'] = 'Extension Status: ';
$_['label_payment_quickpay_contract_id'] = 'Contract ID: ';
$_['label_payment_quickpay_minimum_total'] = 'Minimum Total: ';
$_['label_payment_quickpay_widget_host_url'] = 'Widget Host Url: ';
$_['label_payment_quickpay_sort_order'] = 'Sorting: ';
$_['label_payment_quickpay_pending_order_status'] = 'Pending Order Status: ';
$_['label_payment_quickpay_processing_order_status'] = 'Processing Order Status: ';
$_['label_payment_quickpay_signed_order_status'] = 'Signed Order Status: ';
$_['label_payment_quickpay_confirmed_order_status'] = 'Confirmed Order Status: ';
$_['label_payment_quickpay_canceled_order_status'] = 'Canceled Order Status: ';
$_['label_payment_quickpay_active_order_status'] = 'Active Order Status: ';
$_['label_payment_quickpay_unresolved_order_status'] = 'Unresolved Order Status: ';
$_['label_payment_quickpay_expired_order_status'] = 'Expired Order Status: ';
$_['label_payment_quickpay_jwt_secret'] = 'JWT Secret Code: ';
$_['label_payment_quickpay_jwt_signature_algorithm'] = 'JWT Signature Algorithm: ';
$_['label_payment_quickpay_banks_selection'] = 'Select banks that you\'d wish to add to payment methods';
$_['label_payment_quickpay_banks_select_all'] = 'Select/Unselect all financial institutions';
$_['label_payment_quickpay_shop_name'] = 'Shop name';
$_['label_payment_quickpay_shop_url'] = 'Shop URL';
$_['label_payment_quickpay_send_on_success'] = 'Send if succeeded';
$_['label_payment_quickpay_send_on_failure'] = 'Send if failed';
$_['label_payment_quickpay_periodic_payment_status'] = 'Turn on periodic payments: ';
$_['label_payment_quickpay_remittance_information'] = 'Remittance information';

//TEXT FIELDS
$_['text_payment_quickpay_status_enabled'] = 'Enabled';
$_['text_payment_quickpay_status_disabled'] = 'Disabled';
$_['text_payment_quickpay_send_on_success_enabled'] = 'Yes';
$_['text_payment_quickpay_send_on_success_disabled'] = 'No';
$_['text_payment_quickpay_send_on_failure_enabled'] = 'Yes';
$_['text_payment_quickpay_send_on_failure_disabled'] = 'No';
$_['text_payment_quickpay_periodic_payment_status_enabled'] = 'Yes';
$_['text_payment_quickpay_periodic_payment_status_disabled'] = 'No';

//ENTRIES
$_['entry_payment_quickpay_contract_id'] = 'Conto QuickPay Contract ID';
$_['entry_payment_quickpay_minimum_total'] = 'Min. order amount';
$_['entry_payment_quickpay_widget_host_url'] = 'Leave empty if you want to use a production widget host URL (\'https://quickpay.contomobile.com\')';
$_['entry_payment_quickpay_sort_order'] = 'Conto QuickPay Payment Gateway numerical order in the list';
$_['entry_payment_quickpay_jwt_secret'] = 'Secret code used for JWT';
$_['entry_payment_quickpay_jwt_signature_algorithm'] = 'Signature algorithm used for JWT';
$_['entry_payment_quickpay_shop_name'] = 'Shop name';
$_['entry_payment_quickpay_shop_url'] = 'Shop URL';
$_['entry_payment_quickpay_remittance_information'] = 'Remittance information';

//LIST ITEMS
$_['item_payment_quickpay_jwt_signature_algorithm_hs256'] = 'HS256';

//TOOLTIPS
$_['help_payment_quickpay_jwt_secret'] = 'Base64-encoded secret code given by Conto QuickPay provider after contract conclusion.';
$_['help_payment_quickpay_jwt_signature_algorithm'] = 'Signature algorithm for JWT. If multiple options are available, ask Conto QuickPay provider for the contract-applied algorithm.';
$_['help_payment_quickpay_status'] = 'When the Payment Gateway extension is enabled, it will appear in the list of available payment methods during checkout.';
$_['help_payment_quickpay_contract_id'] = 'Contract ID (number) given by Conto QuickPay provider.';
$_['help_payment_quickpay_sort_order'] = 'Preferred order in the list of payment methods during checkout. Lower value means higher in the list.';
$_['help_payment_quickpay_minimum_total'] = 'Minimum cart total value required for this payment method.';
$_['help_payment_quickpay_widget_host_url'] = 'Format of Host URL: \'https://quickpay.contomobile.com\' (without \' signs) note - don\'t put slash (\'/\') at the end of an URL and also you shouldn\'t use special characters such as *#<> etc.';
$_['help_payment_quickpay_pending_order_status'] = 'Order status after Conto QuickPay is confirmed as a payment method.';
$_['help_payment_quickpay_processing_order_status'] = 'Order status after the client switches back to the e-shop from Conto QuickPay payment window, in both success and cancellation cases.';
$_['help_payment_quickpay_canceled_order_status'] = 'Order status after a callback from Conto QuickPay service informing about payment failure.';
$_['help_payment_quickpay_active_order_status'] = 'Choose order status for Active periodic/recurring payment transaction.';
$_['help_payment_quickpay_unresolved_order_status'] = 'Choose order status for Unresolved periodic/recurring payment transaction.';
$_['help_payment_quickpay_signed_order_status'] = 'Order status after a callback from Conto QuickPay service informing about successfully confirmed payment.';
$_['help_payment_quickpay_confirmed_order_status'] = 'Order status after a callback from Conto QuickPay service informing that the funds have been received. Available only if the beneficiary\'s account is a Contomobile account.';
$_['help_payment_quickpay_expired_order_status'] = 'Order status after callback from QuickPay services is received, informing about a payment, which was idle and not processed for too long.';
$_['help_payment_quickpay_banks_selection'] = 'Select banks that you want to activate (keep in mind that not all banks might be active).';
$_['help_payment_quickpay_shop_name'] = 'Shop name that will be displayed in the payer\'s e-mail notification. Example: Your Shop';
$_['help_payment_quickpay_shop_url'] = 'Shop URL that will be displayed in payer\'s e-mail notification. Example: your-shop.com';
$_['help_payment_quickpay_send_on_success'] = 'Send e-mail to payer if payment has been successful';
$_['help_payment_quickpay_send_on_failure'] = 'Send e-mail to payer if payment failed';
$_['help_payment_quickpay_periodic_payment_status'] = 'Enable/Disable periodic payments (enable only if allowed on FORPOST contract)';
$_['help_payment_quickpay_remittance_information'] = 'Specifying a purpose when creating a periodic payment agreement is optional.';
$_['help_payment_quickpay_load_default'] = 'Load default';

//ERRORS
$_['error_payment_quickpay_contract_id'] = 'Contract ID required!';
$_['error_payment_quickpay_jwt_secret'] = 'JWT secret code required!';
$_['error_payment_quickpay_widget_host_url'] = 'Please enter a valid URL!';
$_['error_misconfiguration'] = 'Please complete the mandatory fields!';
$_['error_permission'] = 'Warning: not enough rights to edit Conto QuickPay extension!';

//EXTENSION
$_['text_extension'] = 'Extensions';
$_['text_payment'] = 'Payment';
$_['text_success'] = 'Conto QuickPay extension settings updated successfully!';
$_['text_edit'] = 'Edit';
$_['text_quickpay'] = '<img src="view/image/payment/quickpay.png" alt="Conto QuickPay" title="Conto QuickPay" style="height:34px;width:112px" />';

$_['label_payment_quickpay_other_banks_selection'] = 'Select other banks to add to payment methods';
$_['label_payment_quickpay_other_banks_select_all'] = 'Select/Unselect other banks';
$_['text_payment_quickpay_other_banks_selection_enabled'] = 'Enabled';
$_['text_payment_quickpay_other_banks_selection_disabled'] = 'Disabled';
$_['help_payment_quickpay_other_banks_selection'] = 'Select other banks for activating ';

$_['error_payment_quickpay_shop_name'] = 'Shop name is required';
$_['error_payment_quickpay_shop_url'] = 'Shop URL is required';
