<?php

class ControllerExtensionPaymentQuickpay extends Controller
{
    public function __construct($registry)
    {
        parent::__construct($registry);

        if (version_compare(phpversion(), '7.1', '>=')) {
            ini_set('serialize_precision', -1);
        }
    }

    const SSL = true;
    const EQUALS = '=';
    const AND_SIGN = '&';
    const EMPTY_SIGN = '';

    const TEXT_SUCCESS = 'text_success';
    const TEXT_HEADING_TITLE = 'heading_title';

    const OPENCART_MARKETPLACE_EXTENSION_ROUTE = 'marketplace/extension';
    const OPENCART_DASHBOARD_ROUTE = 'common/dashboard';
    const OPENCART_EXTENSION_SETTINGS_MODEL = 'setting/setting';
    const OPENCART_ORDER_STATUS_MODEL = 'localisation/order_status';
    const OPENCART_HEADER_CONTROLLER = 'common/header';
    const OPENCART_COLUMN_LEFT_CONTROLLER = 'common/column_left';
    const OPENCART_FOOTER_CONTROLLER = 'common/footer';
    const OPENCART_TOKEN_PARAM_NAME = 'user_token';
    const OPENCART_PAYMENT_TYPE_PARAM_NAME = 'type';
    const OPENCART_PAYMENT_TYPE_PARAM_VALUE = 'payment';

    const PAYMENT_QUICKPAY_EXTENSION_ROUTE = 'extension/payment/quickpay';
    const PAYMENT_QUICKPAY = 'payment_quickpay';
    const PAYMENT_QUICKPAY_CONTRACT_ID = 'payment_quickpay_contract_id';
    const PAYMENT_QUICKPAY_WIDGET_HOST_URL = 'payment_quickpay_widget_host_url';
    const PAYMENT_QUICKPAY_JWT_SECRET = 'payment_quickpay_jwt_secret';
    const PAYMENT_QUICKPAY_BANKS_SELECTION = 'payment_quickpay_banks_selection';
    const PAYMENT_QUICKPAY_OTHER_BANKS_SELECTION = 'payment_quickpay_other_banks_selection';
    const ERROR_PERMISSION = 'error_permission';
    const ERROR_PAYMENT_QUICKPAY_CONTRACT_ID = 'error_payment_quickpay_contract_id';
    const ERROR_PAYMENT_QUICKPAY_JWT_SECRET = 'error_payment_quickpay_jwt_secret';
    const ERROR_PAYMENT_QUICKPAY_WIDGET_HOST_URL = 'error_payment_quickpay_widget_host_url';

    const PAYMENT_QUICKPAY_SHOP_NAME = 'payment_quickpay_shop_name';
    const PAYMENT_QUICKPAY_SHOP_URL = 'payment_quickpay_shop_url';
    const ERROR_PAYMENT_QUICKPAY_SHOP_NAME = 'error_payment_quickpay_shop_name';
    const ERROR_PAYMENT_QUICKPAY_SHOP_URL = 'error_payment_quickpay_shop_url';
    const DEFAULT_HOST = 'https://quickpay.contomobile.com';

    private $error = array();
    private $errorFieldNames = array(
        self::ERROR_PERMISSION,
        self::ERROR_PAYMENT_QUICKPAY_CONTRACT_ID,
        self::ERROR_PAYMENT_QUICKPAY_JWT_SECRET,
        self::ERROR_PAYMENT_QUICKPAY_WIDGET_HOST_URL,
        self::ERROR_PAYMENT_QUICKPAY_SHOP_NAME,
        self::ERROR_PAYMENT_QUICKPAY_SHOP_URL);

    //TWIG CONFIG
    const TWIG_SUCCESS = 'success';
    const TWIG_BREADCRUMBS = 'breadcrumbs';
    const TWIG_BREADCRUMB_TEXT = 'text';
    const TWIG_BREADCRUMB_HREF = 'href';
    const TWIG_ACTION = 'action';
    const TWIG_CANCEL = 'cancel';
    const TWIG_ORDER_STATUSES = 'order_statuses';
    const TWIG_BANKS_SELECTION = 'banks_selection';
    const TWIG_OTHER_BANKS_SELECTION = 'other_banks_selection';
    const TWIG_HEADER = 'header';
    const TWIG_COLUMN_LEFT = 'column_left';
    const TWIG_FOOTER = 'footer';

    private $twigConfigFields = array(
        'payment_quickpay_status',
        self::PAYMENT_QUICKPAY_CONTRACT_ID,
        'payment_quickpay_sort_order',
        'payment_quickpay_minimum_total',
        self::PAYMENT_QUICKPAY_WIDGET_HOST_URL,
        'payment_quickpay_pending_order_status',
        'payment_quickpay_processing_order_status',
        'payment_quickpay_signed_order_status',
        'payment_quickpay_confirmed_order_status',
        'payment_quickpay_canceled_order_status',
        'payment_quickpay_expired_order_status',
        'payment_quickpay_active_order_status',
        'payment_quickpay_unresolved_order_status',
        self::PAYMENT_QUICKPAY_JWT_SECRET,
        self::PAYMENT_QUICKPAY_BANKS_SELECTION,
        self::PAYMENT_QUICKPAY_OTHER_BANKS_SELECTION,
        'payment_quickpay_jwt_signature_algorithm',
        self::PAYMENT_QUICKPAY_SHOP_NAME,
        self::PAYMENT_QUICKPAY_SHOP_URL,
        'payment_quickpay_send_on_success',
        'payment_quickpay_send_on_failure',
        'payment_quickpay_periodic_payment_status',
        'payment_quickpay_remittance_information'
    );
    private $twigBreadCrumbFields = array(
        'text_home' => self::OPENCART_DASHBOARD_ROUTE,
        'text_extension' => self::OPENCART_MARKETPLACE_EXTENSION_ROUTE,
        'heading_title' => self::PAYMENT_QUICKPAY_EXTENSION_ROUTE
    );

    function debug($data)
    {
        $output = $data;
        if (is_array($output))
            $output = implode(',', $output);
        echo "<script>console.log('Debug Objects: " . $output . "' );</script>";
    }

    public function index()
    {
        $json = file_get_contents($this->getBankListUrl());
        $banksJson = json_decode($json, true);
        $countryBanks = $banksJson['countryBanks'];
        $this->load->language(self::PAYMENT_QUICKPAY_EXTENSION_ROUTE);
        $this->document->setTitle($this->language->get(self::TEXT_HEADING_TITLE));
        $this->load->model(self::OPENCART_EXTENSION_SETTINGS_MODEL);

        if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validate()) {
            $this->model_setting_setting->editSetting(self::PAYMENT_QUICKPAY, $this->request->post);
            $this->session->data[self::TWIG_SUCCESS] = $this->language->get(self::TEXT_SUCCESS);
            $this->response->redirect($this->url->link(self::OPENCART_MARKETPLACE_EXTENSION_ROUTE,
                $this->getTokenParam() . self:: AND_SIGN . $this->getPaymentTypeParam(), self::SSL));
        }

        foreach ($this->errorFieldNames as $errorFieldName) {
            $data[$errorFieldName] = $this->generateErrorField($errorFieldName);
        }

        foreach ($this->twigBreadCrumbFields as $fieldName => $fieldValue) {
            $data[self::TWIG_BREADCRUMBS][] = $this->generateBreadCrumbField($fieldName, $fieldValue);
        }

        foreach ($this->twigConfigFields as $configField) {
            $data[$configField] = $this->generateConfigField($configField);
        }

        $data[self::TWIG_ACTION] = $this->url->link(self::PAYMENT_QUICKPAY_EXTENSION_ROUTE,
            $this->getTokenParam(), self::SSL);
        $data[self::TWIG_CANCEL] = $this->url->link(self::OPENCART_MARKETPLACE_EXTENSION_ROUTE,
            $this->getTokenParam() . self:: AND_SIGN . $this->getPaymentTypeParam(), self::SSL);

        $this->load->model(self::OPENCART_ORDER_STATUS_MODEL);
        $data[self::TWIG_ORDER_STATUSES] = $this->model_localisation_order_status->getOrderStatuses();
        $data[self::TWIG_BANKS_SELECTION] = $countryBanks;

        $data[self::TWIG_HEADER] = $this->load->controller(self::OPENCART_HEADER_CONTROLLER);
        $data[self::TWIG_COLUMN_LEFT] = $this->load->controller(self::OPENCART_COLUMN_LEFT_CONTROLLER);
        $data[self::TWIG_FOOTER] = $this->load->controller(self::OPENCART_FOOTER_CONTROLLER);

        $this->response->setOutput($this->load->view(self::PAYMENT_QUICKPAY_EXTENSION_ROUTE, $data));
    }

    private function getTokenParam()
    {
        return self::OPENCART_TOKEN_PARAM_NAME . self::EQUALS . $this->session->data[self::OPENCART_TOKEN_PARAM_NAME];
    }

    private function getPaymentTypeParam()
    {
        return self::OPENCART_PAYMENT_TYPE_PARAM_NAME . self::EQUALS . self::OPENCART_PAYMENT_TYPE_PARAM_VALUE;
    }

    private function generateErrorField($fieldName)
    {
        if (isset($this->error[$fieldName])) {
            return $this->error[$fieldName];
        } else {
            return self::EMPTY_SIGN;
        }
    }

    private function generateConfigField($fieldName)
    {
        if (isset($this->request->post[$fieldName])) {
            return $this->request->post[$fieldName];
        } else {
            return $this->config->get($fieldName);
        }
    }

    private function generateBreadCrumbField($fieldName, $fieldValue)
    {
        if ($fieldValue == self::OPENCART_DASHBOARD_ROUTE || $fieldValue == self::PAYMENT_QUICKPAY_EXTENSION_ROUTE) {
            $query = $this->getTokenParam();
        } else {
            $query = $this->getTokenParam() . self:: AND_SIGN . $this->getPaymentTypeParam();
        }
        return array(
            self::TWIG_BREADCRUMB_TEXT => $this->language->get($fieldName),
            self::TWIG_BREADCRUMB_HREF => $this->url->link($fieldValue, $query, self::SSL)
        );
    }

    protected function validate()
    {
        if (!$this->user->hasPermission('modify', self::PAYMENT_QUICKPAY_EXTENSION_ROUTE)) {
            $this->error[self::ERROR_PERMISSION] = $this->language->get(self::ERROR_PERMISSION);
        }
        if (!$this->request->post[self::PAYMENT_QUICKPAY_CONTRACT_ID]) {
            $this->error[self::ERROR_PAYMENT_QUICKPAY_CONTRACT_ID] = $this->language->get(self::ERROR_PAYMENT_QUICKPAY_CONTRACT_ID);
        }
        if (!$this->request->post[self::PAYMENT_QUICKPAY_JWT_SECRET]) {
            $this->error[self::ERROR_PAYMENT_QUICKPAY_JWT_SECRET] = $this->language->get(self::ERROR_PAYMENT_QUICKPAY_JWT_SECRET);
        }
        $postWidgetHostUrl = $this->request->post[self::PAYMENT_QUICKPAY_WIDGET_HOST_URL];
        if ($postWidgetHostUrl && !filter_var($postWidgetHostUrl, FILTER_VALIDATE_URL)) {
            $this->error[self::ERROR_PAYMENT_QUICKPAY_WIDGET_HOST_URL] = $this->language->get(self::ERROR_PAYMENT_QUICKPAY_WIDGET_HOST_URL);
        }

        if (!$this->request->post[self::PAYMENT_QUICKPAY_SHOP_NAME]) {
            $this->error[self::ERROR_PAYMENT_QUICKPAY_SHOP_NAME] = $this->language->get(self::ERROR_PAYMENT_QUICKPAY_SHOP_NAME);
        }

        if (!$this->request->post[self::PAYMENT_QUICKPAY_SHOP_URL]) {
            $this->error[self::ERROR_PAYMENT_QUICKPAY_SHOP_URL] = $this->language->get(self::ERROR_PAYMENT_QUICKPAY_SHOP_URL);
        }


        return !$this->error;
    }

    private function getBankListUrl(): string
    {
        $host = $this->config->get(self::PAYMENT_QUICKPAY_WIDGET_HOST_URL) ?? self::DEFAULT_HOST;
        return $host . '/api/setup/country-banks';
    }
}